/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import java.util.List;
import java.util.function.Function;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_4587;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.GeckoLibClientServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.RenderPassInfo;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;

public class GeoObjectRenderer<T extends GeoAnimatable, O, R extends GeoRenderState>
implements GeoRenderer<T, O, R> {
    protected final GeoRenderLayersContainer<T, O, R> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;

    public GeoObjectRenderer(GeoModel<T> model) {
        this.model = model;
    }

    @Override
    public void scaleModelForRender(RenderPassInfo<R> renderPassInfo, float widthScale, float heightScale) {
        GeoRenderer.super.scaleModelForRender(renderPassInfo, this.scaleWidth * widthScale, this.scaleHeight * heightScale);
    }

    @Override
    public void adjustRenderPose(RenderPassInfo<R> renderPassInfo) {
        renderPassInfo.poseStack().method_46416(0.5f, 0.51f, 0.5f);
    }

    public void performRenderPass(T animatable, O relatedObject, class_4587 poseStack, class_11659 renderTasks, class_12075 cameraState, int packedLight, int partialTick) {
        this.performRenderPass(animatable, relatedObject, poseStack, renderTasks, cameraState, packedLight, partialTick, null);
    }

    public void performRenderPass(T animatable, O relatedObject, class_4587 poseStack, class_11659 renderTasks, class_12075 cameraState, int packedLight, int partialTick, @Nullable RenderPassInfo.BoneUpdater<R> boneUpdater) {
        R renderState = this.fillRenderState(animatable, relatedObject, this.createRenderState(animatable, null), partialTick);
        renderState.addGeckolibData(DataTickets.PACKED_LIGHT, packedLight);
        GeoRenderer.super.performRenderPass(renderState, poseStack, renderTasks, cameraState, boneUpdater);
    }

    @Override
    public R createRenderState(T animatable, @Nullable O relatedObject) {
        return (R)new GeoRenderState.Impl();
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public List<GeoRenderLayer<T, O, R>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoObjectRenderer<T, O, R> withRenderLayer(Function<? super GeoObjectRenderer<T, O, R>, GeoRenderLayer<T, O, R>> renderLayer) {
        return this.withRenderLayer(renderLayer.apply(this));
    }

    public GeoObjectRenderer<T, O, R> withRenderLayer(GeoRenderLayer<T, O, R> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoObjectRenderer<T, O, R> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoObjectRenderer<T, O, R> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibClientServices.EVENTS.fireCompileObjectRenderLayers(this);
    }

    @Override
    public void fireCompileRenderStateEvent(T animatable, @Nullable O relatedObject, R renderState, float partialTick) {
        GeckoLibClientServices.EVENTS.fireCompileObjectRenderState(this, renderState, animatable, relatedObject);
    }

    @Override
    public boolean firePreRenderEvent(RenderPassInfo<R> renderPassInfo, class_11659 renderTasks) {
        return GeckoLibClientServices.EVENTS.fireObjectPreRender(renderPassInfo, renderTasks);
    }
}

